package theGhastModding.midiEditor.midi;

import java.util.ArrayList;
import java.util.List;

public class Slice {
	
	private List<Note> notes;
	private long length;
	private long startTick;
	private double longestNote = 0;
	
	public Slice(long length, long startTick){
		this.length = length;
		this.startTick = startTick;
		notes = new ArrayList<Note>();
	}
	
	public synchronized List<Note> getNotes(){
		return notes;
	}
	
	public synchronized void setNotes(List<Note> newNotes){
		this.notes.clear();
		this.notes.addAll(newNotes);
	}
	
	public synchronized void addNote(Note n){
		if(n.getEnd() - startTick > longestNote){
			longestNote = n.getEnd() - startTick;
		}
		this.notes.add(n);
	}
	
	public long getLength() {
		return length;
	}
	
	public void setLength(long length) {
		this.length = length;
	}
	
	public String toString(){
		return "Slice length=" + Long.toString(length) + ", Note count=" + Integer.toString(notes.size());
	}
	
	public long getStartTick() {
		return startTick;
	}
	
	public void setStartTick(long startTick) {
		this.startTick = startTick;
	}
	
	public double longestNote(){
		if(longestNote < length){
			return length;
		}
		return longestNote;
	}
	
}