package theGhastModding.midiPlayer.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingConstants;

import theGhastModding.midiPlayer.main.TheGhastMidiPlayerMain;
import theGhastModding.midiPlayer.resources.Textures;
import theGhastModding.synthesizer.main.TGMSynthesizer;

@SuppressWarnings("serial")
public class AboutDialog extends JDialog {
	
	public AboutDialog(){
		super(TheGhastMidiPlayerMain.frame, "About");
		setModal(true);
		setLocationRelativeTo(TheGhastMidiPlayerMain.frame);
		this.setResizable(false);
		this.getContentPane().setLayout(null);
		this.getContentPane().setPreferredSize(new Dimension(400,100));
		
		JButton btnOk = new JButton("OK");
		btnOk.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				setVisible(false);
			}
		});
		btnOk.setBounds(10, 66, 380, 23);
		getContentPane().add(btnOk);
		
		JLabel lblAppinfo = new JLabel(TheGhastMidiPlayerMain.NAME + " by TheGhastModding");
		lblAppinfo.setHorizontalAlignment(SwingConstants.CENTER);
		lblAppinfo.setBounds(10, 11, 380, 14);
		getContentPane().add(lblAppinfo);
		
		JLabel lblAppversion = new JLabel("Version " + TheGhastMidiPlayerMain.VERSION);
		lblAppversion.setHorizontalAlignment(SwingConstants.CENTER);
		lblAppversion.setBounds(10, 30, 380, 14);
		getContentPane().add(lblAppversion);
		
		JLabel lblSynthversion = new JLabel("TheGhastModding's synthesizer version: " + TGMSynthesizer.getVersion());
		lblSynthversion.setHorizontalAlignment(SwingConstants.CENTER);
		lblSynthversion.setBounds(10, 50, 380, 14);
		getContentPane().add(lblSynthversion);
		
		BufferedImage resizedImage = new BufferedImage(46,46,BufferedImage.TYPE_INT_RGB);
		resizedImage.getGraphics().drawImage(Textures.icon, 0, 0, 46, 46, null);
		
		JLabel lblIcon = new JLabel(new ImageIcon(resizedImage));
		lblIcon.setBounds(0, 0, 46, 46);
		getContentPane().add(lblIcon);
		setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);
		
		pack();
		setVisible(false);
	}
}