package theGhastModding.midiPlayer.main;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.URL;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

import theGhastModding.midiPlayer.gui.TheGhastMidiPlayerPanel;

public class TheGhastMidiPlayerMain {
	
	public static JFrame frame;
	public static final String NAME = "TheGhastMIDIPlayer";
	public static final String VERSION = "b.6";
	public static boolean smaller = false;
	
	public static void main(String[] args){
		for(String s:args){
			if(s.equalsIgnoreCase("-small")){
				smaller = true;
			}
		}
		try {
	        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		}catch(Exception e){
			e.printStackTrace();
		}
		boolean update = false;
		if(!System.getProperty("user.name").equals("lucah")) update = Updater.checkForUpdates();
		if(update){
			int option = JOptionPane.showConfirmDialog(frame, "An new version is available to download. Would you like to download it now?", "Message", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
			if(option == 0){
				try {
					Desktop.getDesktop().browse(new URL("https://www.dropbox.com/s/paquj4f8178c03l/TheGhastMidiPlayer_64bit.zip?dl=0").toURI());
				} catch(Exception e2){
		        	JOptionPane.showMessageDialog(frame, "Error opening download page", "Error", JOptionPane.ERROR_MESSAGE);
		        	e2.printStackTrace();
		        	return;
				}
			}
		}
		int cores = Runtime.getRuntime().availableProcessors();
		int res = JOptionPane.showConfirmDialog(frame, "The Java VM has determined that your CPU has " + Integer.toString(cores) + " thread" + (cores > 1 ? "s" : "") + ". Is this correct? (Press 'YES' if you're not sure)", "Confirm cores", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
		if(res == 1){
			String input = JOptionPane.showInputDialog(frame, "In this case, please enter the correct number of threads below.", "Enter number of cores", JOptionPane.INFORMATION_MESSAGE);
			try {
				cores = Integer.parseInt(input);
				if(cores < 0){
					JOptionPane.showMessageDialog(frame, "Veeeery funny.", "...", JOptionPane.ERROR_MESSAGE);
					System.exit(1);
				}
			}catch(Exception e){
				JOptionPane.showMessageDialog(frame, "Error: " + e.getMessage() + ". You may have entered something that wasn't a number.", "Error", JOptionPane.ERROR_MESSAGE);
				e.printStackTrace();
				System.exit(1);
			}
		}
		if(cores > 128) cores = 128;
		frame = new JFrame(NAME);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setResizable(false);
		Toolkit kit = Toolkit.getDefaultToolkit();
		Dimension d = kit.getScreenSize();
		frame.setLocation((int)(d.getWidth() / 2 - (smaller ? 480 : 640)), (int)(d.getHeight() / 2 -  (smaller ? 270 : 360)));
		TheGhastMidiPlayerPanel panel = new TheGhastMidiPlayerPanel(cores);
		frame.setContentPane(panel);
		frame.pack();
		frame.setVisible(true);
	}
	
}