package theGhastModding.midiPlayer.midi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Slice {
	
	private Map<Integer, List<Note>> notes;
	private long length;
	private long startTick;
	private double longestNote = 0;
	
	public Slice(long length, long startTick, int numCores){
		this.length = length;
		this.startTick = startTick;
		notes = new HashMap<Integer, List<Note>>();
		for(int i = 0; i < numCores; i++) notes.put(i, new ArrayList<Note>());
	}
	
	public synchronized List<Note> getNotesForCore(int core){
		return notes.get(core);
	}
	
	public synchronized void setNotes(List<Note> newNotes, int core){
		this.notes.get(core).clear();
		this.notes.get(core).addAll(newNotes);
	}
	
	public synchronized void addNote(Note n, int core){
		if(n.getEnd() - startTick > longestNote){
			longestNote = n.getEnd() - startTick;
		}
		this.notes.get(core).add(n);
	}
	
	public long getLength() {
		return length;
	}
	
	public void setLength(long length) {
		this.length = length;
	}
	
	public String toString(){
		return "Slice length=" + Long.toString(length) + ", Note count=" + Integer.toString(notes.size());
	}
	
	public long getStartTick() {
		return startTick;
	}
	
	public void setStartTick(long startTick) {
		this.startTick = startTick;
	}
	
	public double longestNote(){
		return longestNote;
	}
	
}